//+-------------------------------------------------------------------
#property copyright "mladen"
#property link      "www.forex-tsd.com"
//+-------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1  OrangeRed
#property indicator_color2  DarkGray
#property indicator_color3  DarkGray
#property indicator_width1  2
#property indicator_style2  STYLE_DOT
#property indicator_style3  STYLE_DOT
#property indicator_level1  0
#property indicator_levelcolor Gray

//
//
//
//
//

extern int Price         = PRICE_CLOSE;
extern int PriceShift    = 0;
extern int EmaPeriod     = 32;
extern int HighLowPeriod = 100;
extern int LwmaPeriod    = 6;
extern int ObOsPeriod    = 25;

double beh[];
double levu[];
double levd[];

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int init()
{
   SetIndexBuffer(0,beh);
   SetIndexBuffer(1,levu);
   SetIndexBuffer(2,levd);
   IndicatorShortName("Behgozin Strength Finder ("+EmaPeriod+","+HighLowPeriod+","+LwmaPeriod+","+ObOsPeriod+","+PriceShift+")");
   return(0);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double work[];
int start()
{
   int i,r,counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
            int limit=Bars-counted_bars;
            if (ArrayRange(work,0)!=Bars) ArrayResize(work,Bars);

   //
   //
   //
   //
   //

   double alpha = 2.0/(1.0+ObOsPeriod);           
   for(i=limit, r=Bars-i-1; i>=0; i--,r++)
   {
      if ((i+PriceShift)>=0)
      {
         double price = iMA(NULL,0,1,0,MODE_SMA,Price,i+PriceShift);
         double ema   = iEma(price,EmaPeriod,r);
            if (ema != 0)
                  work[r] = 100.0*(price-ema)/ema;
            else  work[r] = 0;    
         double max = work[r];
         double min = work[r];
         for (int k=1; k<HighLowPeriod && (r-k)>=0; k++)
         {
            max = MathMax(max,work[r-k]);
            min = MathMin(min,work[r-k]);
         }
         beh[i]   = iLwma(work[r]*(max-min),LwmaPeriod,r);
         levu[i]  = levu[i+1];
         levd[i]  = levd[i+1];
            if (beh[i]>0) levu[i] = levu[i+1]+alpha*(beh[i]-levu[i+1]);
            if (beh[i]<0) levd[i] = levd[i+1]+alpha*(beh[i]-levd[i+1]);
      }
   }
   return(0);         
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double workEma[][1];
double iEma(double price, double period, int r, int instanceNo=0)
{
   if (ArrayRange(workEma,0)!= Bars) ArrayResize(workEma,Bars);

   //
   //
   //
   //
   //
      
   double alpha = 2.0 / (1.0+period);
          workEma[r][instanceNo] = workEma[r-1][instanceNo]+alpha*(price-workEma[r-1][instanceNo]);
   return(workEma[r][instanceNo]);
}

//
//
//
//
//

double workLwma[][2];
double iLwma(double price, double period, int r, int instanceNo=0)
{
   if (ArrayRange(workLwma,0)!= Bars) ArrayResize(workLwma,Bars);
   
   //
   //
   //
   //
   //
   
   workLwma[r][instanceNo] = price;
      double sumw = period;
      double sum  = period*price;

      for(int k=1; k<period && (r-k)>=0; k++)
      {
         double weight = period-k;
                sumw  += weight;
                sum   += weight*workLwma[r-k][instanceNo];  
      }             
      return(sum/sumw);
}